/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.data;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.data.DataKeyBase;
import icyllis.flexmark.util.data.DataValueFactory;
import icyllis.flexmark.util.data.DataValueNullableFactory;
import icyllis.flexmark.util.data.MutableDataHolder;
import java.util.function.Supplier;

public class NullableDataKey<T>
extends DataKeyBase<T> {
    public NullableDataKey(@NotNull String name, @Nullable T defaultValue, @NotNull DataValueFactory<T> factory) {
        super(name, defaultValue, factory);
    }

    public NullableDataKey(@NotNull String name, @NotNull DataValueNullableFactory<T> factory) {
        super(name, factory.apply(null), factory);
    }

    public NullableDataKey(@NotNull String name, @NotNull Supplier<T> supplier) {
        super(name, supplier.get(), holder -> supplier.get());
    }

    public NullableDataKey(@NotNull String name, @NotNull DataKeyBase<T> defaultKey) {
        this(name, defaultKey.getDefaultValue(), defaultKey::get);
    }

    public NullableDataKey(@NotNull String name, @Nullable T defaultValue) {
        this(name, defaultValue, options -> defaultValue);
    }

    public NullableDataKey(@NotNull String name) {
        this(name, null, options -> null);
    }

    @Override
    @Nullable
    public T getDefaultValue() {
        return super.getDefaultValue();
    }

    @Override
    @Nullable
    public T getDefaultValue(@NotNull DataHolder holder) {
        return super.getDefaultValue(holder);
    }

    @Override
    @Nullable
    public T get(@Nullable DataHolder holder) {
        return super.get(holder);
    }

    @Override
    @NotNull
    public MutableDataHolder set(@NotNull MutableDataHolder dataHolder, @Nullable T value) {
        return dataHolder.set(this, value);
    }

    @Override
    public String toString() {
        T defaultValue = this.getDefaultValue();
        if (defaultValue != null) {
            return "DataKey<" + defaultValue.getClass().getSimpleName() + "> " + this.getName();
        }
        return "DataKey<null> " + this.getName();
    }
}

